/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */
package com.gravatar.restapi.models

import com.squareup.moshi.Json
import com.squareup.moshi.JsonClass
import java.util.Objects

/**
 * A user's profile information.
 *
 * @param hash The SHA256 hash of the user's primary email address.
 * @param displayName The user's display name. This is the name that is displayed on their profile.
 * @param profileUrl The full URL for the user's profile.
 * @param avatarUrl The URL for the user's avatar image if it has been set.
 * @param avatarAltText The alt text for the user's avatar image if it has been set.
 * @param location The user's location.
 * @param description The about section on a user's profile.
 * @param jobTitle The user's job title.
 * @param company The user's current company's name.
 * @param verifiedAccounts A list of verified accounts the user has added to their profile. This is limited to a max of 4 in unauthenticated requests.
 * @param pronunciation The phonetic pronunciation of the user's name.
 * @param pronouns The pronouns the user uses.
 * @param userId The unique user ID. NOTE: This is only provided in OAuth2 authenticated requests.
 * @param userLogin The user's login name. NOTE: This is only provided in OAuth2 authenticated requests.
 * @param timezone The timezone the user has. This is only provided in authenticated API requests.
 * @param languages The languages the user knows. This is only provided in authenticated API requests.
 * @param firstName User's first name. This is only provided in authenticated API requests.
 * @param lastName User's last name. This is only provided in authenticated API requests.
 * @param isOrganization Whether user is an organization. This is only provided in authenticated API requests.
 * @param headerImage The header image used in the main profile card.
 * @param backgroundColor The profile background color.
 * @param links A list of links the user has added to their profile. This is only provided in authenticated API requests.
 * @param interests A list of interests the user has added to their profile. This is only provided in authenticated API requests.
 * @param payments
 * @param contactInfo
 * @param gallery Additional images a user has uploaded. This is only provided in authenticated API requests.
 * @param numberVerifiedAccounts The number of verified accounts the user has added to their profile. This count includes verified accounts the user is hiding from their profile. This is only provided in authenticated API requests.
 * @param lastProfileEdit The date and time (UTC) the user last edited their profile. This is only provided in authenticated API requests.
 * @param registrationDate The date the user registered their account. This is only provided in authenticated API requests.
 * @param sectionVisibility
 */
@JsonClass(generateAdapter = true)
public class Profile internal constructor(
    // The SHA256 hash of the user's primary email address.
    @Json(name = "hash")
    public val hash: kotlin.String,
    // The user's display name. This is the name that is displayed on their profile.
    @Json(name = "display_name")
    public val displayName: kotlin.String,
    // The full URL for the user's profile.
    @Json(name = "profile_url")
    public val profileUrl: java.net.URI,
    // The URL for the user's avatar image if it has been set.
    @Json(name = "avatar_url")
    public val avatarUrl: java.net.URI,
    // The alt text for the user's avatar image if it has been set.
    @Json(name = "avatar_alt_text")
    public val avatarAltText: kotlin.String,
    // The user's location.
    @Json(name = "location")
    public val location: kotlin.String,
    // The about section on a user's profile.
    @Json(name = "description")
    public val description: kotlin.String,
    // The user's job title.
    @Json(name = "job_title")
    public val jobTitle: kotlin.String,
    // The user's current company's name.
    @Json(name = "company")
    public val company: kotlin.String,
    // A list of verified accounts the user has added to their profile. This is limited to a max of 4 in unauthenticated requests.
    @Json(name = "verified_accounts")
    public val verifiedAccounts: kotlin.collections.List<VerifiedAccount>,
    // The phonetic pronunciation of the user's name.
    @Json(name = "pronunciation")
    public val pronunciation: kotlin.String,
    // The pronouns the user uses.
    @Json(name = "pronouns")
    public val pronouns: kotlin.String,
    // The unique user ID. NOTE: This is only provided in OAuth2 authenticated requests.
    @Json(name = "user_id")
    public val userId: kotlin.Int? = null,
    // The user's login name. NOTE: This is only provided in OAuth2 authenticated requests.
    @Json(name = "user_login")
    public val userLogin: kotlin.String? = null,
    // The timezone the user has. This is only provided in authenticated API requests.
    @Json(name = "timezone")
    public val timezone: kotlin.String? = null,
    // The languages the user knows. This is only provided in authenticated API requests.
    @Json(name = "languages")
    public val languages: kotlin.collections.List<Language>? = null,
    // User's first name. This is only provided in authenticated API requests.
    @Json(name = "first_name")
    public val firstName: kotlin.String? = null,
    // User's last name. This is only provided in authenticated API requests.
    @Json(name = "last_name")
    public val lastName: kotlin.String? = null,
    // Whether user is an organization. This is only provided in authenticated API requests.
    @Json(name = "is_organization")
    public val isOrganization: kotlin.Boolean? = null,
    // The header image used in the main profile card.
    @Json(name = "header_image")
    public val headerImage: kotlin.String? = null,
    // The profile background color.
    @Json(name = "background_color")
    public val backgroundColor: kotlin.String? = null,
    // A list of links the user has added to their profile. This is only provided in authenticated API requests.
    @Json(name = "links")
    public val links: kotlin.collections.List<Link>? = null,
    // A list of interests the user has added to their profile. This is only provided in authenticated API requests.
    @Json(name = "interests")
    public val interests: kotlin.collections.List<Interest>? = null,
    @Json(name = "payments")
    public val payments: ProfilePayments? = null,
    @Json(name = "contact_info")
    public val contactInfo: ProfileContactInfo? = null,
    // Additional images a user has uploaded. This is only provided in authenticated API requests.
    @Json(name = "gallery")
    public val gallery: kotlin.collections.List<GalleryImage>? = null,
    // The number of verified accounts the user has added to their profile. This count includes verified accounts the user is hiding from their profile. This is only provided in authenticated API requests.
    @Json(name = "number_verified_accounts")
    public val numberVerifiedAccounts: kotlin.Int? = null,
    // The date and time (UTC) the user last edited their profile. This is only provided in authenticated API requests.
    @Json(name = "last_profile_edit")
    public val lastProfileEdit: String? = null,
    // The date the user registered their account. This is only provided in authenticated API requests.
    @Json(name = "registration_date")
    public val registrationDate: String? = null,
    @Json(name = "section_visibility")
    public val sectionVisibility: ProfileSectionVisibility? = null,
) {
    override fun toString(): String = "Profile(hash=$hash, displayName=$displayName, profileUrl=$profileUrl, avatarUrl=$avatarUrl, avatarAltText=$avatarAltText, location=$location, description=$description, jobTitle=$jobTitle, company=$company, verifiedAccounts=$verifiedAccounts, pronunciation=$pronunciation, pronouns=$pronouns, userId=$userId, userLogin=$userLogin, timezone=$timezone, languages=$languages, firstName=$firstName, lastName=$lastName, isOrganization=$isOrganization, headerImage=$headerImage, backgroundColor=$backgroundColor, links=$links, interests=$interests, payments=$payments, contactInfo=$contactInfo, gallery=$gallery, numberVerifiedAccounts=$numberVerifiedAccounts, lastProfileEdit=$lastProfileEdit, registrationDate=$registrationDate, sectionVisibility=$sectionVisibility)"

    override fun equals(other: Any?): Boolean = other is Profile &&
        hash == other.hash &&
        displayName == other.displayName &&
        profileUrl == other.profileUrl &&
        avatarUrl == other.avatarUrl &&
        avatarAltText == other.avatarAltText &&
        location == other.location &&
        description == other.description &&
        jobTitle == other.jobTitle &&
        company == other.company &&
        verifiedAccounts == other.verifiedAccounts &&
        pronunciation == other.pronunciation &&
        pronouns == other.pronouns &&
        userId == other.userId &&
        userLogin == other.userLogin &&
        timezone == other.timezone &&
        languages == other.languages &&
        firstName == other.firstName &&
        lastName == other.lastName &&
        isOrganization == other.isOrganization &&
        headerImage == other.headerImage &&
        backgroundColor == other.backgroundColor &&
        links == other.links &&
        interests == other.interests &&
        payments == other.payments &&
        contactInfo == other.contactInfo &&
        gallery == other.gallery &&
        numberVerifiedAccounts == other.numberVerifiedAccounts &&
        lastProfileEdit == other.lastProfileEdit &&
        registrationDate == other.registrationDate &&
        sectionVisibility == other.sectionVisibility

    override fun hashCode(): Int = Objects.hash(hash, displayName, profileUrl, avatarUrl, avatarAltText, location, description, jobTitle, company, verifiedAccounts, pronunciation, pronouns, userId, userLogin, timezone, languages, firstName, lastName, isOrganization, headerImage, backgroundColor, links, interests, payments, contactInfo, gallery, numberVerifiedAccounts, lastProfileEdit, registrationDate, sectionVisibility)

    public class Builder {
        // The SHA256 hash of the user's primary email address.
        @set:JvmSynthetic // Hide 'void' setter from Java
        public var hash: kotlin.String? = null

        // The user's display name. This is the name that is displayed on their profile.
        @set:JvmSynthetic // Hide 'void' setter from Java
        public var displayName: kotlin.String? = null

        // The full URL for the user's profile.
        @set:JvmSynthetic // Hide 'void' setter from Java
        public var profileUrl: java.net.URI? = null

        // The URL for the user's avatar image if it has been set.
        @set:JvmSynthetic // Hide 'void' setter from Java
        public var avatarUrl: java.net.URI? = null

        // The alt text for the user's avatar image if it has been set.
        @set:JvmSynthetic // Hide 'void' setter from Java
        public var avatarAltText: kotlin.String? = null

        // The user's location.
        @set:JvmSynthetic // Hide 'void' setter from Java
        public var location: kotlin.String? = null

        // The about section on a user's profile.
        @set:JvmSynthetic // Hide 'void' setter from Java
        public var description: kotlin.String? = null

        // The user's job title.
        @set:JvmSynthetic // Hide 'void' setter from Java
        public var jobTitle: kotlin.String? = null

        // The user's current company's name.
        @set:JvmSynthetic // Hide 'void' setter from Java
        public var company: kotlin.String? = null

        // A list of verified accounts the user has added to their profile. This is limited to a max of 4 in unauthenticated requests.
        @set:JvmSynthetic // Hide 'void' setter from Java
        public var verifiedAccounts: kotlin.collections.List<VerifiedAccount>? = null

        // The phonetic pronunciation of the user's name.
        @set:JvmSynthetic // Hide 'void' setter from Java
        public var pronunciation: kotlin.String? = null

        // The pronouns the user uses.
        @set:JvmSynthetic // Hide 'void' setter from Java
        public var pronouns: kotlin.String? = null

        // The unique user ID. NOTE: This is only provided in OAuth2 authenticated requests.
        @set:JvmSynthetic // Hide 'void' setter from Java
        public var userId: kotlin.Int? = null

        // The user's login name. NOTE: This is only provided in OAuth2 authenticated requests.
        @set:JvmSynthetic // Hide 'void' setter from Java
        public var userLogin: kotlin.String? = null

        // The timezone the user has. This is only provided in authenticated API requests.
        @set:JvmSynthetic // Hide 'void' setter from Java
        public var timezone: kotlin.String? = null

        // The languages the user knows. This is only provided in authenticated API requests.
        @set:JvmSynthetic // Hide 'void' setter from Java
        public var languages: kotlin.collections.List<Language>? = null

        // User's first name. This is only provided in authenticated API requests.
        @set:JvmSynthetic // Hide 'void' setter from Java
        public var firstName: kotlin.String? = null

        // User's last name. This is only provided in authenticated API requests.
        @set:JvmSynthetic // Hide 'void' setter from Java
        public var lastName: kotlin.String? = null

        // Whether user is an organization. This is only provided in authenticated API requests.
        @set:JvmSynthetic // Hide 'void' setter from Java
        public var isOrganization: kotlin.Boolean? = null

        // The header image used in the main profile card.
        @set:JvmSynthetic // Hide 'void' setter from Java
        public var headerImage: kotlin.String? = null

        // The profile background color.
        @set:JvmSynthetic // Hide 'void' setter from Java
        public var backgroundColor: kotlin.String? = null

        // A list of links the user has added to their profile. This is only provided in authenticated API requests.
        @set:JvmSynthetic // Hide 'void' setter from Java
        public var links: kotlin.collections.List<Link>? = null

        // A list of interests the user has added to their profile. This is only provided in authenticated API requests.
        @set:JvmSynthetic // Hide 'void' setter from Java
        public var interests: kotlin.collections.List<Interest>? = null

        @set:JvmSynthetic // Hide 'void' setter from Java
        public var payments: ProfilePayments? = null

        @set:JvmSynthetic // Hide 'void' setter from Java
        public var contactInfo: ProfileContactInfo? = null

        // Additional images a user has uploaded. This is only provided in authenticated API requests.
        @set:JvmSynthetic // Hide 'void' setter from Java
        public var gallery: kotlin.collections.List<GalleryImage>? = null

        // The number of verified accounts the user has added to their profile. This count includes verified accounts the user is hiding from their profile. This is only provided in authenticated API requests.
        @set:JvmSynthetic // Hide 'void' setter from Java
        public var numberVerifiedAccounts: kotlin.Int? = null

        // The date and time (UTC) the user last edited their profile. This is only provided in authenticated API requests.
        @set:JvmSynthetic // Hide 'void' setter from Java
        public var lastProfileEdit: String? = null

        // The date the user registered their account. This is only provided in authenticated API requests.
        @set:JvmSynthetic // Hide 'void' setter from Java
        public var registrationDate: String? = null

        @set:JvmSynthetic // Hide 'void' setter from Java
        public var sectionVisibility: ProfileSectionVisibility? = null

        public fun setHash(hash: kotlin.String?): Builder = apply { this.hash = hash }

        public fun setDisplayName(displayName: kotlin.String?): Builder = apply { this.displayName = displayName }

        public fun setProfileUrl(profileUrl: java.net.URI?): Builder = apply { this.profileUrl = profileUrl }

        public fun setAvatarUrl(avatarUrl: java.net.URI?): Builder = apply { this.avatarUrl = avatarUrl }

        public fun setAvatarAltText(avatarAltText: kotlin.String?): Builder = apply { this.avatarAltText = avatarAltText }

        public fun setLocation(location: kotlin.String?): Builder = apply { this.location = location }

        public fun setDescription(description: kotlin.String?): Builder = apply { this.description = description }

        public fun setJobTitle(jobTitle: kotlin.String?): Builder = apply { this.jobTitle = jobTitle }

        public fun setCompany(company: kotlin.String?): Builder = apply { this.company = company }

        public fun setVerifiedAccounts(verifiedAccounts: kotlin.collections.List<VerifiedAccount>?): Builder = apply { this.verifiedAccounts = verifiedAccounts }

        public fun setPronunciation(pronunciation: kotlin.String?): Builder = apply { this.pronunciation = pronunciation }

        public fun setPronouns(pronouns: kotlin.String?): Builder = apply { this.pronouns = pronouns }

        public fun setUserId(userId: kotlin.Int?): Builder = apply { this.userId = userId }

        public fun setUserLogin(userLogin: kotlin.String?): Builder = apply { this.userLogin = userLogin }

        public fun setTimezone(timezone: kotlin.String?): Builder = apply { this.timezone = timezone }

        public fun setLanguages(languages: kotlin.collections.List<Language>?): Builder = apply { this.languages = languages }

        public fun setFirstName(firstName: kotlin.String?): Builder = apply { this.firstName = firstName }

        public fun setLastName(lastName: kotlin.String?): Builder = apply { this.lastName = lastName }

        public fun setIsOrganization(isOrganization: kotlin.Boolean?): Builder = apply { this.isOrganization = isOrganization }

        public fun setHeaderImage(headerImage: kotlin.String?): Builder = apply { this.headerImage = headerImage }

        public fun setBackgroundColor(backgroundColor: kotlin.String?): Builder = apply { this.backgroundColor = backgroundColor }

        public fun setLinks(links: kotlin.collections.List<Link>?): Builder = apply { this.links = links }

        public fun setInterests(interests: kotlin.collections.List<Interest>?): Builder = apply { this.interests = interests }

        public fun setPayments(payments: ProfilePayments?): Builder = apply { this.payments = payments }

        public fun setContactInfo(contactInfo: ProfileContactInfo?): Builder = apply { this.contactInfo = contactInfo }

        public fun setGallery(gallery: kotlin.collections.List<GalleryImage>?): Builder = apply { this.gallery = gallery }

        public fun setNumberVerifiedAccounts(numberVerifiedAccounts: kotlin.Int?): Builder = apply { this.numberVerifiedAccounts = numberVerifiedAccounts }

        public fun setLastProfileEdit(lastProfileEdit: String?): Builder = apply { this.lastProfileEdit = lastProfileEdit }

        public fun setRegistrationDate(registrationDate: String?): Builder = apply { this.registrationDate = registrationDate }

        public fun setSectionVisibility(sectionVisibility: ProfileSectionVisibility?): Builder = apply { this.sectionVisibility = sectionVisibility }

        public fun build(): Profile = Profile(hash!!, displayName!!, profileUrl!!, avatarUrl!!, avatarAltText!!, location!!, description!!, jobTitle!!, company!!, verifiedAccounts!!, pronunciation!!, pronouns!!, userId, userLogin, timezone, languages, firstName, lastName, isOrganization, headerImage, backgroundColor, links, interests, payments, contactInfo, gallery, numberVerifiedAccounts, lastProfileEdit, registrationDate, sectionVisibility)
    }
}

@JvmSynthetic // Hide from Java callers who should use Builder.
public fun Profile(initializer: Profile.Builder.() -> Unit): Profile {
    return Profile.Builder().apply(initializer).build()
}
