/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */
package com.gravatar.restapi.apis

import com.gravatar.restapi.infrastructure.ApiClient
import com.gravatar.restapi.infrastructure.ApiResponse
import com.gravatar.restapi.infrastructure.MultiValueMap
import com.gravatar.restapi.infrastructure.RequestConfig
import com.gravatar.restapi.infrastructure.RequestMethod
import com.gravatar.restapi.models.AssociatedResponse
import com.gravatar.restapi.models.Profile
import com.gravatar.restapi.models.UpdateProfileRequest
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import okhttp3.HttpUrl
import okhttp3.OkHttpClient
import java.io.IOException

internal class ProfilesApi(
    basePath: kotlin.String = defaultBasePath,
    client: OkHttpClient = ApiClient.defaultClient,
) : ApiClient(basePath, client) {
    internal companion object {
        @JvmStatic
        val defaultBasePath: String = "https://api.gravatar.com/v3"
    }

    /**
     * GET /me/associated-email
     * Check if the email is associated with the authenticated user
     * Checks if the provided email address is associated with the authenticated user.
     * @param emailHash The hash of the email address to check.
     * @return ApiResponse<AssociatedResponse?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    internal suspend fun associatedEmail(emailHash: kotlin.String): ApiResponse<AssociatedResponse> =
        withContext(Dispatchers.IO) {
            val localVariableConfig = associatedEmailRequestConfig(emailHash = emailHash)

            return@withContext request<Unit, AssociatedResponse>(
                localVariableConfig,
            )
        }

    /**
     * To obtain the request config of the operation associatedEmail
     *
     * @param emailHash The hash of the email address to check.
     * @return RequestConfig
     */
    private fun associatedEmailRequestConfig(emailHash: kotlin.String): RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("email_hash", listOf(emailHash.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/me/associated-email",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody,
        )
    }

    /**
     * GET /me/profile
     * Get profile information for the authenticated user
     * Returns the information available for the authenticated user. It&#39;s equivalent to the full profile information available in the &#x60;/profiles/{profileIdentifier}&#x60; endpoint.
     * @return ApiResponse<Profile?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    internal suspend fun getProfile(): ApiResponse<Profile> = withContext(Dispatchers.IO) {
        val localVariableConfig = getProfileRequestConfig()

        return@withContext request<Unit, Profile>(
            localVariableConfig,
        )
    }

    /**
     * To obtain the request config of the operation getProfile
     *
     * @return RequestConfig
     */
    private fun getProfileRequestConfig(): RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/me/profile",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody,
        )
    }

    /**
     * GET /profiles/{profileIdentifier}
     * Get profile by identifier
     * Returns a profile by the given identifier.
     * @param profileIdentifier This can either be an SHA256 hash of an email address or profile URL slug.
     * @return ApiResponse<Profile?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    internal suspend fun getProfileById(profileIdentifier: kotlin.String): ApiResponse<Profile> =
        withContext(Dispatchers.IO) {
            val localVariableConfig = getProfileByIdRequestConfig(profileIdentifier = profileIdentifier)

            return@withContext request<Unit, Profile>(
                localVariableConfig,
            )
        }

    /**
     * To obtain the request config of the operation getProfileById
     *
     * @param profileIdentifier This can either be an SHA256 hash of an email address or profile URL slug.
     * @return RequestConfig
     */
    private fun getProfileByIdRequestConfig(profileIdentifier: kotlin.String): RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/profiles/{profileIdentifier}".replace(
                "{" + "profileIdentifier" + "}",
                encodeURIComponent(profileIdentifier.toString()),
            ),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody,
        )
    }

    /**
     * PATCH /me/profile
     * Update profile information for the authenticated user
     * Updates the profile information for the authenticated user. Only a subset of &#x60;Profile&#x60; fields are available for update. Partial updates are supported, so only the provided fields will be updated. To unset a field, set it explicitly to an empty string.
     * @param updateProfileRequest
     * @return ApiResponse<Profile?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    internal suspend fun updateProfile(updateProfileRequest: UpdateProfileRequest): ApiResponse<Profile> =
        withContext(Dispatchers.IO) {
            val localVariableConfig = updateProfileRequestConfig(updateProfileRequest = updateProfileRequest)

            return@withContext request<UpdateProfileRequest, Profile>(
                localVariableConfig,
            )
        }

    /**
     * To obtain the request config of the operation updateProfile
     *
     * @param updateProfileRequest
     * @return RequestConfig
     */
    private fun updateProfileRequestConfig(
        updateProfileRequest: UpdateProfileRequest,
    ): RequestConfig<UpdateProfileRequest> {
        val localVariableBody = updateProfileRequest
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.PATCH,
            path = "/me/profile",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody,
        )
    }

    private fun encodeURIComponent(uriComponent: kotlin.String): kotlin.String =
        HttpUrl.Builder().scheme("http").host("localhost").addPathSegment(uriComponent).build().encodedPathSegments[0]
}
