package com.gravatar.quickeditor.ui.avatarpicker

import android.net.Uri
import com.gravatar.restapi.models.Avatar
import com.gravatar.types.Email
import java.io.File

internal sealed class AvatarPickerAction {
    data object AvatarSelected : AvatarPickerAction()

    data class LaunchImageCropper(val imageUri: Uri, val tempFile: File) : AvatarPickerAction()

    data object AvatarSelectionFailed : AvatarPickerAction()

    data object InvokeAuthFailed : AvatarPickerAction()

    data object AvatarDownloadStarted : AvatarPickerAction()

    data object DownloadManagerNotAvailable : AvatarPickerAction()

    data class AvatarDeletionFailed(val avatarId: String) : AvatarPickerAction()

    data object AvatarRatingUpdated : AvatarPickerAction()

    data object AvatarRatingUpdateFailed : AvatarPickerAction()

    data class LaunchAvatarAltText(val email: Email, val avatar: Avatar) : AvatarPickerAction()
}
