/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */
package com.gravatar.restapi.apis

import com.gravatar.restapi.models.AssociatedResponse
import com.gravatar.restapi.models.Profile
import retrofit2.Response
import retrofit2.http.GET
import retrofit2.http.Path
import retrofit2.http.Query

internal interface ProfilesApi {
    /**
     * Check if the email is associated with the authenticated user
     * Checks if the provided email address is associated with the authenticated user.
     * Responses:
     *  - 200: The email is associated with the authenticated user
     *  - 401: Not Authorized
     *  - 403: Insufficient Scope
     *
     * @param emailHash The hash of the email address to check.
     * @return [AssociatedResponse]
     */
    @GET("me/associated-email")
    suspend fun associatedEmail(
        @Query("email_hash") emailHash: kotlin.String,
    ): Response<AssociatedResponse>

    /**
     * Get profile by identifier
     * Returns a profile by the given identifier.
     * Responses:
     *  - 200: Successful response
     *  - 404: Profile not found
     *  - 429: Rate limit exceeded
     *  - 500: Internal server error
     *
     * @param profileIdentifier This can either be an SHA256 hash of an email address or profile URL slug.
     * @return [Profile]
     */
    @GET("profiles/{profileIdentifier}")
    suspend fun getProfileById(
        @Path("profileIdentifier") profileIdentifier: kotlin.String,
    ): Response<Profile>
}
