/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */
package com.gravatar.restapi.apis

import com.gravatar.restapi.models.Avatar
import com.gravatar.restapi.models.SetEmailAvatarRequest
import com.gravatar.restapi.models.UpdateAvatarRequest
import okhttp3.MultipartBody
import retrofit2.Response
import retrofit2.http.Body
import retrofit2.http.DELETE
import retrofit2.http.GET
import retrofit2.http.Multipart
import retrofit2.http.PATCH
import retrofit2.http.POST
import retrofit2.http.Part
import retrofit2.http.Path
import retrofit2.http.Query

internal interface AvatarsApi {
    /**
     * Delete avatar
     * Deletes a specific avatar for the authenticated user.
     * Responses:
     *  - 200: Avatar deleted successfully
     *  - 401: Not Authorized
     *  - 403: Insufficient Scope
     *  - 404: Avatar not found
     *
     * @param imageHash The hash of the avatar to delete.
     * @return [Unit]
     */
    @DELETE("me/avatars/{imageHash}")
    suspend fun deleteAvatar(
        @Path("imageHash") imageHash: kotlin.String,
    ): Response<Unit>

    /**
     * List avatars
     * Retrieves a list of available avatars for the authenticated user.
     * Responses:
     *  - 200: Successful retrieval of avatars
     *  - 401: Not Authorized
     *  - 403: Insufficient Scope
     *
     * @param selectedEmailHash The SHA256 hash of the email address used to determine which avatar is selected. The &#39;selected&#39; attribute in the avatar list will be set to &#39;true&#39; for the avatar associated with this email. (optional, default to "")
     * @return [kotlin.collections.List<Avatar>]
     */
    @GET("me/avatars")
    suspend fun getAvatars(
        @Query("selected_email_hash") selectedEmailHash: kotlin.String? = "",
    ): Response<kotlin.collections.List<Avatar>>

    /**
     * Set avatar for the hashed email
     * Sets the avatar for the provided email hash.
     * Responses:
     *  - 200: Avatar successfully set
     *  - 401: Not Authorized
     *  - 403: Insufficient Scope
     *
     * @param imageId Image ID of the avatar to set as the provided hashed email avatar.
     * @param setEmailAvatarRequest Avatar selection details
     * @return [Unit]
     */
    @POST("me/avatars/{imageId}/email")
    suspend fun setEmailAvatar(
        @Path("imageId") imageId: kotlin.String,
        @Body setEmailAvatarRequest: SetEmailAvatarRequest,
    ): Response<Unit>

    /**
     * Update avatar data
     * Updates the avatar data for a given avatar for the authenticated user.
     * Responses:
     *  - 200: Avatar updated successfully
     *  - 401: Not Authorized
     *  - 403: Insufficient Scope
     *  - 404: Avatar not found
     *
     * @param imageHash The hash of the avatar to update.
     * @param updateAvatarRequest
     * @return [Avatar]
     */
    @PATCH("me/avatars/{imageHash}")
    suspend fun updateAvatar(
        @Path("imageHash") imageHash: kotlin.String,
        @Body updateAvatarRequest: UpdateAvatarRequest,
    ): Response<Avatar>

    /**
     * Upload new avatar image
     * Uploads a new avatar image for the authenticated user.
     * Responses:
     *  - 200: Avatar uploaded successfully
     *  - 400: Invalid request
     *  - 401: Not Authorized
     *  - 403: Insufficient Scope
     *
     * @param `data` The avatar image file
     * @param selectedEmailHash The SHA256 hash of email. If provided, the uploaded image will be selected as the avatar for this email. (optional)
     * @param selectAvatar Determines if the uploaded image should be set as the avatar for the email. If not passed, the image is only selected as the email&#39;s avatar if no previous avatar has been set. Accepts &#39;1&#39;/&#39;true&#39; to always set the avatar or &#39;0&#39;/&#39;false&#39; to never set the avatar. (optional, default to null)
     * @return [Avatar]
     */
    @Multipart
    @POST("me/avatars")
    suspend fun uploadAvatar(
        @Part `data`: MultipartBody.Part,
        @Query("selected_email_hash") selectedEmailHash: kotlin.String? = null,
        @Query("select_avatar") selectAvatar: kotlin.Boolean? = null,
    ): Response<Avatar>
}
