# Migration from 2.x to 2.3.0

## GravatarOAuthActivity

In version 2.3.0, the `GravatarOAuthActivity` was introduced to handle OAuth authentication with Gravatar. 
This means you no longer need to set up your Activity with the `launchMode=singleTask` to handle the `onNewIntent` method for OAuth redirection.

The Quick Editor will still work if you won't change it but it's highly recommended to migrate to the new `GravatarOAuthActivity` as this behavior will be removed in the future.

### Steps to Migrate

1. **Remove the extra config from you own Activity**:
   If you have previously added this to you AndroidManifest.xml:

   ```xml
   <activity
       android:name=".YourActivity"
       android:launchMode="singleTask"
       ...>
       <intent-filter android:autoVerify="true">
          <action android:name="android.intent.action.VIEW" />
        
          <category android:name="android.intent.category.DEFAULT" />
           <category android:name="android.intent.category.BROWSABLE" />
        
           <data
               android:scheme="https"
               android:host="yourhost.com"
               android:pathPrefix="/redirect-url"
           />
       </intent-filter>
   </activity>
   ```
   
    You can remove the `android:launchMode="singleTask"` and the `<intent-filter>` block.

2. **Add `GravatarOAuthActivity`**:
   Ensure that the `GravatarOAuthActivity` is declared in your `AndroidManifest.xml`:

   ```xml
    <activity
        android:name="com.gravatar.quickeditor.ui.oauth.GravatarOAuthActivity"
        tools:node="merge">
        <intent-filter android:autoVerify="true">
            <action android:name="android.intent.action.VIEW" />
    
            <category android:name="android.intent.category.DEFAULT" />
            <category android:name="android.intent.category.BROWSABLE" />
    
            <data
                android:scheme="https"
                android:host="yourhost.com"
                android:pathPrefix="/redirect-url"
            />
        </intent-filter>
    </activity>
    ```
