# How to Contribute

First off, thank you for contributing! We're excited to collaborate with you! 🎉

The following is a set of guidelines for the many ways you can join our collective effort.

Before anything else, please take a moment to read our [Code of Conduct](CODE-OF-CONDUCT.md). We expect all participants, from full-timers to occasional tinkerers, to uphold it.

## Security

If you happen to find a security vulnerability, we would appreciate you letting us know at https://hackerone.com/automattic and allowing us to respond before disclosing the issue publicly.

## Reporting Bugs, Asking Questions, and Suggesting Features

Have a suggestion or feedback? Please go to [Issues](https://github.com/Automattic/Gravatar-SDK-Android/issues) and [open a new issue](https://github.com/Automattic/Gravatar-SDK-Android/issues/new). Prefix the title with a category like _"Bug:"_, _"Question:"_, or _"Feature Request:"_. Screenshots help us resolve issues and answer questions faster, so thanks for including some if you can.

Before you ask a question, it is best to search for existing [Issues](https://github.com/Automattic/Gravatar-SDK-Android/issues) that might help you. In case you find a suitable issue, you can ask your question by adding a comment there.

Similarly, before reporting a bug, check if there is not already a bug report existing for your case.

## Submitting Code Changes

If you're just getting started and want to familiarize yourself with the app’s code, we suggest looking at [these issues](https://github.com/Automattic/Gravatar-SDK-Android/issues?q=is%3Aissue+is%3Aopen+label%3A%22good+first+issue%22) with the **good first issue** label. But if you’d like to tackle something different, you're more than welcome to visit the [Issues](https://github.com/Automattic/Gravatar-SDK-Android/issues) page and pick an item that interests you.

We always try to avoid duplicating efforts.  If you decide to work on an issue, leave a comment to state your intent. If you choose to focus on a new feature, or the change you’re proposing is significant, we recommend waiting for a response before proceeding. The issue may no longer align with project goals.

If the change is trivial, feel free to send a pull request without notifying us.

### Pull Requests and Code Reviews

All code contributions pass through pull requests. If you haven't created a pull request before, we recommend this free video series, [How to Contribute to an Open Source Project on GitHub](https://egghead.io/courses/how-to-contribute-to-an-open-source-project-on-github). 

The core team monitors and reviews all pull requests. Depending on the changes, we will either approve them or close them with an explanation. We might also work with you to improve a pull request before approval.

Note: If you are part of the org, and have the necessary permissions for the repo, please add yourself to the PR as an `assignee`, and add the appropriate GitHub label(s) and Milestone.

### PR merge policy

* PRs require one reviewer to approve the PR before it can be merged to the base branch
* We keep the PR git history when merging (merge via "merge commit")
* The reviewer who approved the PR will merge it right after approval (without waiting for the PR author) if all checks are green.

### Development Practices

Have look at the [Coding Style](README.md#coding-style) guide to learn how to format your code so it passes the convention and quality checks like the rest of the project.
